
import cadquery as cq

# Workspace and sketch creation
bench = cq.Workplane("XY")

# Creating the main body of the bench to resemble the crossbar in "h"
main_body = bench.rect(10, 3).extrude(1)

# Creating legs and backrest to give the appearance of vertical posts in 'h'
legs_backrest = bench.union(
    # Positioning one leg
    bench.workplane(offset=-1.5).center(5, 0).rect(1, 3).extrude(1),
    # Positioning the second leg
    bench.workplane(offset=-1.5).center(-5, 0).rect(1, 3).extrude(1),
    # Positioning the backrest
    bench.workplane(offset=1.5).center(0, 1.5).rect(10, 1).extrude(1)
)

# Combining parts to form the complete bench
complete_bench = main_body.union(legs_backrest)

# Exporting the modified bench design
complete_bench.val().exportStl("Refine_2.stl")
