
import cadquery as cq

# Create a new document
result = cq.Workplane("XY")

# Parameters
diameter1 = 50
diameter2 = 20
separation = diameter1

radius1 = diameter1 / 2
radius2 = diameter2 / 2
distance_centers = radius1 + radius2 + separation

# Create primary circle
circle1 = result.circle(radius1).translate((distance_centers / 2, 0))

# Create secondary circle
circle2 = result.circle(radius2).translate((-distance_centers / 2, 0))

# Drawing tangents between two circles based on geometry calculation
# Assuming horizontal tangents, calculating positions of tangency
x_offset = (radius1 * radius2 / (radius1 + radius2)) * separation / (radius1 + radius2)
y_offset = (radius1 + radius2) * (separation**2 - (radius2 - radius1)**2)**0.5 / (radius1 + radius2)

# Tangents
result = circle1.add(circle2)
result = result.moveTo(distance_centers / 2 - x_offset, y_offset)
result = result.lineTo(-distance_centers / 2 + x_offset, y_offset)
result = result.moveTo(distance_centers / 2 - x_offset, -y_offset)
result = result.lineTo(-distance_centers / 2 + x_offset, -y_offset)

# Extrude the sketch
extrusion_height = 5  # Extrusion height
final_result = result.extrude(extrusion_height)

# Export the result as STL
final_result.val().exportStl("Refine_2.stl")
