
import cadquery as cq

# Define the dimensions of the outer and inner squares
outer_size = 10.0  # side length of the outer square
inner_size = 8.0   # side length of the inner square, should be smaller than outer_size
length = 20.0      # extrude length

# Create the outer square and extrude it
result_outer = cq.Workplane("XZ").rect(outer_size, outer_size).extrude(length)

# Create the inner square and extrude it negativly with *hole length* should be same as length for consistency
result_hole = cq.Workplane("XZ").rect(inner_size, inner_size).extrude(length)

# Combine the shapes to create a pipe
result_pipe = result_outer.cut(result_hole)

# Export the modified result with the corrected file name
result_pipe.val().exportStl("Refine_2.stl")
