
import cadquery as cq

# This code block creates a flat rhombus shape and extrudes it vertically upwards to form a 3D object.

# Define vector pairs for creating the edges of the rhombus
points = [(0, 0), (10, 0), (15, 5), (5, 5)]

# Create the rhombus and extrude it vertically
result = cq.Workplane("XY").polyline(points).close().extrude(5)

# Export the 3D model to an STL file
result.val().exportStl("Refine_2.stl")
