
import cadquery as cq

# Define the size of the frame
frame_size = 10.0
frame_thickness = 1.0

# Create the outer square and immediately extrude it into a cube
outer_cube = cq.Workplane("XY").rect(frame_size, frame_size).extrude(frame_thickness)

# Create the inner square (the hole) and extrude it into a cube
inner_cube = cq.Workplane("XY").rect(frame_size - frame_thickness*2, frame_size - frame_thickness*2).extrude(frame_thickness)

# Subtract the inner cube from the outer cube to create the frame
frame = outer_cube.cut(inner_cube)

# Export the result
frame.val().exportStl("Refine_1.stl")
