
import cadquery as cq

# Parameters for the pipe and flange
pipe_od = 10.0  # Outer diameter of the pipe
pipe_id = 8.0  # Inner diameter of the pipe
pipe_length = 50.0  # Length of the pipe
flange_od = 15.0  # Outer diameter of the flange
flange_thickness = 1.0  # Thickness of the flange
flange_position = pipe_length - flange_thickness  # Adjust flange to be at the end of the pipe

# Create the pipe
pipe = (
    cq.Workplane("XY")
    .circle(pipe_od / 2.0)
    .extrude(pipe_length)
    .faces("<Z")
    .workplane()
    .circle(pipe_id / 2.0)
    .cutThruAll()
)

# Create the flange at one end
flange = (
    cq.Workplane("XY")
    .circle(flange_od / 2.0)
    .extrude(-flange_thickness)  # Negative extrusion to place the flange at the end
)

# Combine the pipe with the flanged end
result = pipe.union(flange.translate((0, 0, flange_position)))  # Translate flange to end of the pipe

# Export the final result
result.val().exportStl("Refine_1.stl")
