
import cadquery as cq

# Parameters for the pipe and flange
pipe_od = 10.0  # Outer diameter of the pipe
pipe_id = 8.0  # Inner diameter of the pipe
pipe_length = 50.0  # Length of the pipe
flange_od = 15.0  # Outer diameter of the flange
flange_thickness = 1.0  # Thickness of the flange
flange_position = pipe_length  # Exact end position of the pipe for flange

# Create the pipe
pipe = (
    cq.Workplane("XY")
    .circle(pipe_od / 2.0)
    .extrude(pipe_length)
    .faces("<Z")
    .workplane()
    .circle(pipe_id / 2.0)
    .cutThruAll()
)

# Create the flange at one end
# Ensure that the flange is created at the positive Z-end of the pipe
flange = (
    cq.Workplane("XY")
    .circle(flange_od / 2.0)
    .extrude(flange_thickness)  # Correct positive extrusion
)

# Positioning the flange at the bottom end of the pipe
adjusted_result = (
    pipe
    .faces(">Z")  # Select the face on the positive Z side to attach the flange
    .workplane()
    .union(flange)
)

# Export the adjusted final result
adjusted_result.val().exportStl("Refine_2.stl")
