
import cadquery as cq

# Define the diameters of the two holes
d1 = 10.0  # Diameter of the smaller hole
d2 = d1 * 2/3  # Corrected here, now d1 is the smaller, d2 is larger

# Switch d2 to be the larger diameter for compliance with the description requirement
d1, d2 = d2, d1 

# Define the lengths of the two sections of the pipe
l1 = 20.0  # Length of the section with the smaller hole
l2 = 20.0  # Length of the section with the larger hole

# Define the thickness of the pipe wall
t = 2.0

# Create the first section of the pipe with the smaller hole
pipe = (
    cq.Workplane("XY")
    .circle(d1 / 2.0 + t)
    .circle(d1 / 2.0)
    .extrude(l1)
)

# Create the second section of the pipe with the larger hole
pipe = (
    pipe.faces(">Z")
    .workplane()
    .circle(d2 / 2.0 + t)
    .circle(d2 / 2.0)
    .extrude(l2)
)

# Export the result
pipe.val().exportStl("Refine_2.stl")
