
import cadquery as cq

# Adjust points to ensure the top two edges are split into two with obtuse angles very close to 180 degrees.
pts = [
    (0, 0),                # Bottom left
    (2, 0),                # Bottom right
    (2.75, 1),             # Right middle, breaking edge into two
    (2, 2),                # Top right
    (0, 2),                # Top left
    (-0.75, 1)             # Left middle, breaking edge into two
]

# Create the workplane and the modified pentagon
result = cq.Workplane("XY").polyline(pts).close()

# Extrude to create a 3D object
result = result.extrude(1)

# Export the result with the new filename for clarity
result.val().exportStl("Refine_1.stl")
