
import cadquery as cq

# Create the U-shaped sketch and extrude it
U_shape = (
    cq.Workplane("XY")
    .moveTo(-1.5, 0)
    .lineTo(1.5, 0)
    .lineTo(1.5, 2)
    .lineTo(-1.5, 2)
    .close()
    .extrude(1)
)

# Create the square sketches at the exact spot to ensure overlap on U's boundary
square_left = (
    cq.Workplane("XY")
    .moveTo(-1.5, 0)  # Adjust this position to ensure exact overlap
    .rect(1, 1)
    .extrude(1)
)

square_right = (
    cq.Workplane("XY")
    .moveTo(1, 0)  # Adjust this position to ensure exact overlap
    .rect(1, 1)
    .extrude(1)
)

# Combine all the parts
result = U_shape.union(square_left).union(square_right)

# Export the result with the updated filename
result.val().exportStl("Refine_1.stl")
