
import cadquery as cq

# Create the U-shaped sketch and extrude it
U_shape = (
    cq.Workplane("XY")
    .moveTo(-1.5, 0)
    .lineTo(1.5, 0)
    .lineTo(1.5, 2)
    .lineTo(-1.5, 2)
    .close()
    .extrude(1)
)

# Adjustments to the positions for the left and right squares to ensure they slightly overlap
# Adjust square size and position to ensure better overlap
square_left = (
    cq.Workplane("XY")
    .moveTo(-1.6, -0.1)  # Move slightly out for visible overlap
    .rect(1, 1)
    .extrude(1)
)

square_right = (
    cq.Workplane("XY")
    .moveTo(1.5, -0.1)  # Move slightly out for visible overlap
    .rect(1, 1)
    .extrude(1)
)

# Combine all the parts
result = U_shape.union(square_left).union(square_right)

# Export the result with the updated filename
result.val().exportStl("Refine_2.stl")
