
import cadquery as cq

# Define the points the polyline will be drawn through
points = [(0, 0), (0, 10), (10, 10), (10, 8), (2, 8), (2, 0)]

# Create a workplane and draw the polyline
r = cq.Workplane("front").polyline(points)

# Mirror the polyline about the Y axis and extrude it into a 3D object
result = r.close().extrude(2)

# Export the result to STL with the new file name
result.val().exportStl("Refine_1.stl")
