
import cadquery as cq

# Dimensions for the block and cylinders
block_length = 20.0
block_width = 10.0
block_height = 5.0
cylinder_dia = block_length / 4
cylinder_height = block_height / 2

# Create the block
result = cq.Workplane("XY").box(block_length, block_width, block_height)

# Create the cylinders, positioning them at the bottom of the block, centered
cylinder1 = (
    cq.Workplane("XY")
    .moveTo(block_length / 4, block_width / 2)
    .circle(cylinder_dia / 2)
    .extrude(-cylinder_height)  # using negative extrude to push it to the bottom
)
cylinder2 = (
    cq.Workplane("XY")
    .moveTo(3 * block_length / 4, block_width / 2)
    .circle(cylinder_dia / 2)
    .extrude(-cylinder_height)  # using negative extrude to push it to the bottom
)

# Combine the block and cylinders
result = result.cut(cylinder1).cut(cylinder2)

# Export the result
result.val().exportStl("Refine_1.stl")
