
import cadquery as cq

# Define the dimensions of the trapezoid
base = 10.0
top = 5.0
height = 7.0

# Create the trapezoid
result = (
    cq.Workplane("front")
    .moveTo(-base / 2.0, 0)
    .lineTo(-top / 2.0, height)
    .lineTo(top / 2.0, height)
    .lineTo(base / 2.0, 0)
    .close()
    .extrude(1.0)  # Extrude the 2D trapezoid into a 3D object
)

# Export the result to STL
result.val().exportStl("Generated.stl")
