
import cadquery as cq

# Create new set of points that better define the 'R'
pts_R = [
    (0, 0),  # Start bottom left
    (0, 2),  # Move up to top left
    (0.5, 2),  # Move right at top
    (0.5, 1.25),  # Start of inner arc bottom
    (0.5, 1.75)   # Start of inner arc top
]

# Create a workplane to draw the letter R
r_shape = cq.Workplane("front").moveTo(0, 0)

# Draw main body of R
r_shape = r_shape.polyline(pts_R)

# Add arc for the leg of R
r_shape = r_shape.threePointArc((1, 1.5), (0.5, 1.25))

# Close the shape
r_shape = r_shape.lineTo(0, 0).close()

# Extrude the sketch into a 3D solid
result = r_shape.extrude(0.5)

# Export the result to STL with correct filename
result.val().exportStl("Refine_1.stl")
