
import cadquery as cq

# Create a workplane
result = cq.Workplane("XY")

# Create a large annulus shape
result = result.circle(10).circle(5)  # Outer radius 10, inner radius 5

# Extrude the annulus shape
result = result.extrude(5)

# Select the bottom face of the cylinder
result = result.faces("<Z").workplane()

# Close the bottom by creating a circular face that matches the outer diameter
# Extrude positively to fully close the bottom
bottom_close = result.circle(10).extrude(0.1)  # Extruding a small positive amount to effectively seal the bottom

# Combine both parts
result = result.union(bottom_close)

# Save the updated output
result.val().exportStl("Refine_2.stl")
