
import cadquery as cq

# Create the base of the thermometer
base = cq.Workplane("XY").circle(5).extrude(0.5)

# Create the stem of the thermometer, attached to the top edge of the circle
stem = (
    cq.Workplane("XY")
    .moveTo(0, 5)
    .rect(1, 50)
    .extrude(0.4)
    .translate((0, 25, 0.05))  # Translated to align with the top edge of the circle and slightly shifted upward
)

# Combine the base and the stem
thermometer = base.union(stem)

# Export the result
thermometer.val().exportStl("Refine_1.stl")
