
import cadquery as cq

# Define the dimensions of the brick
brick_length = 1.0
brick_width = 1.0
brick_height = 1.8
circle_height = brick_height / 7
circle_diameter = brick_width / 2

# Create the base of the brick with updated hollow logic
# Ensuring that only the top part of the brick is left intact after hollowing
brick = (
    cq.Workplane("XY")
    .box(brick_length, brick_width, brick_height)
    .faces("<Z")
    .shell(-0.1)
)

# Create the circle on top of the brick with accurate proportions
brick = (
    brick.faces(">Z")
    .workplane(centerOption="CenterOfMass")
    .circle(circle_diameter / 2)  # Ensure the circle's diameter is correct
    .extrude(circle_height)
)

# Export the adjusted model as STL with updated name
brick.val().exportStl("Refine_2.stl")
