
import cadquery as cq

# Define the dimensions
outer_radius = 10.0  # Outer radius of the cylinder in millimeters
inner_radius = 0.1   # Radius of the small hole in millimeters
height = 20.0        # Height of the cylinder in millimeters

# Create a new workplane that will contain our model
workplane = cq.Workplane("XY")

# Create the outer cylinder
result = workplane.circle(outer_radius).extrude(height)

# Create the small hole by selecting the top face and adding a centered hole
result = result.faces(">Z").workplane().circle(inner_radius).cutThruAll()

# Export the result as an STL file with a refined filename
result.val().exportStl("Refine_2.stl")
