
import cadquery as cq
import math  # for calculations

# Parameters for the ring and holes
outer_diameter = 20.0
width = 2.0
inner_diameter = outer_diameter - 2 * width
hole_diameter = 1.0
hole_radius = (outer_diameter / 2 - width) 

# Create the ring
ring = cq.Workplane("XY").circle(outer_diameter / 2).circle(inner_diameter / 2).extrude(width)

# Create holes evenly spaced at 120 degree intervals in a triangular pattern
for angle in range(0, 360, 120):
    x = hole_radius * math.cos(math.radians(angle))
    y = hole_radius * math.sin(math.radians(angle))
    ring = ring.faces(">Z").workplane().center(x, y).hole(hole_diameter)

# Export the result
ring.val().exportStl("Refine_1.stl")
