
import cadquery as cq

# Define the dimensions of the rectangle
length = 80.0
width = 60.0
thickness = 10.0

# Define the dimensions of the hole
hole_length = length / 8
hole_width = width / 8

# Create the rectangle and extrude it
result = (
    cq.Workplane("XY")
    .rect(length, width)
    .extrude(thickness)
)

# Create the hole
# Adjust the center of the hole to be closer to the bottom
# Origin 'width/4' moved to '3*width/4' to shift the hole toward the bottom
result = (
    result.faces(">Z")
    .workplane(centerOption='CenterOfBoundBox')
    .rect(hole_length, hole_width)
    .translate((0, -3*width/8, 0))  # Adjust position closer to the bottom
    .cutBlind(-thickness)
)

# Export the result
result.val().exportStl("Refine_2.stl")
