
import cadquery as cq

# Parameters for the cylinder and holes
cylinder_height = 100.0
cylinder_diameter = 10.0
hole_diameter = 8.0

# Create the cylinder
result = cq.Workplane("XY").circle(cylinder_diameter / 2).extrude(cylinder_height)

# Create the top hole
result = result.faces(">Z").workplane().hole(hole_diameter)

# Create two bottom holes: one closer to the center and the other further from the center
result = result.faces("<Z").workplane().center(-cylinder_diameter / 6, 0).hole(hole_diameter)
result = result.faces("<Z").workplane().center(cylinder_diameter / 3, 0).hole(hole_diameter)

# Export the result
result.val().exportStl("Refine_1.stl")
