
import cadquery as cq

# Define the dimensions
width = 15.0
height = 1.0
thickness = 0.2
hole_width = (width / 3.0) - 0.5  # slightly smaller than one third of the width
hole_height = height / 2.0
hole_spacing = width / 6.0

# Create the base rectangle
result = cq.Workplane("XY").box(width, height, thickness)

# Adjust the positions and ensure two distinct holes
# Compute the center positions based on width, spacing and hole size
center_x_1 = -(hole_width / 2 + hole_spacing / 2)
center_x_2 = (hole_width / 2 + hole_spacing / 2)

# Create the holes - placing them symmetrically on the shape
result = (
    result.faces(">Z")
          .workplane(centerOption="CenterOfBoundBox")
          .rect(center_x_2 - center_x_1 + hole_width, hole_height, forConstruction=True)
          .vertices("<XY")
          .rect(hole_width, hole_height)
          .vertices(">XY")
          .rect(hole_width, hole_height)
          .cutBlind(-thickness)
)

# Export the refined result
result.val().exportStl("Refine_2.stl")
