
import cadquery as cq

# Create the base rectangle and extrude it to form the rectangular prism
result = cq.Workplane("front").rect(10, 20).extrude(30)

# Create a hollow cylinder by cutting it through from the top of the rectangle
# Ensure it cuts through the entire body
result = result.faces(">Z").workplane(centerOption="CenterOfBoundBox").hole(10, 30)

# Save the output
result.val().exportStl("Refine_2.stl")
