
import cadquery as cq

# Create a large hollow cylinder
outer_radius = 50.0
inner_radius = 45.0
height = 100.0
result = cq.Workplane("XY").circle(outer_radius).circle(inner_radius).extrude(height)

# Create a circle at the bottom of the cylinder to close it
bottom_face = result.faces("<Z").workplane()
result = bottom_face.circle(outer_radius).extrude(-5)  # Negative extrusion to close the bottom

# Save the output
result.val().exportStl("Refine_1.stl")
