
import cadquery as cq

# Create a large hollow cylinder
outer_radius = 50.0
inner_radius = 45.0
height = 100.0
result = cq.Workplane("XY").circle(outer_radius).circle(inner_radius).extrude(height)

# Create a circle at the bottom of the cylinder to close it
bottom_face = result.faces("<Z").workplane()
result = bottom_face.circle(outer_radius).extrude(-5)  # Negative extrusion to close the bottom

# Create a tiny hollow circle in the middle of the bottom
tiny_hollow_radius = 10.0  # Example radius for the tiny hollow circle
result = bottom_face.circle(tiny_hollow_radius).cutThruAll()  # Cut through all creates the hollow

# Save the updated output
result.val().exportStl("Refine_2.stl")
