
import cadquery as cq

# Define the dimensions
original_size = 10.0
original_extrusion = 1.0
hollow_size = original_size / 2
second_size = original_size * 3 / 4
second_extrusion = original_extrusion / 4
tiny_size = 0.5
tiny_extrusion = 0.1

# Create the original rectangle and extrude it
result = cq.Workplane("XY").rect(original_size, original_size).extrude(original_extrusion)

# Create the hollow in the center
result = result.faces(">Z").workplane().rect(hollow_size, hollow_size).cutThruAll()

# Create the second rectangle on top and extrude it
result = result.faces(">Z").workplane().rect(second_size, second_size).extrude(second_extrusion)

# Correctly position the tiny rectangles on the sides at X-axis and slightly below at Y-axis
tiny_offset_x = second_size * (3/8 + 1/8)  # Adjusted X offset for correct positioning along the first line of symmetry
tiny_offset_y = -second_size/4           # Adjusted Y offset to place the rectangles slightly below the second line of symmetry

# Create the tiny rectangles on the right and left side
result = result.faces(">Z").workplane().center(-tiny_offset_x, tiny_offset_y).rect(tiny_size, tiny_size).extrude(tiny_extrusion)
result = result.faces(">Z").workplane().center(tiny_offset_x, tiny_offset_y).rect(tiny_size, tiny_size).extrude(tiny_extrusion)

# Export the refined model
result.val().exportStl("Refine_2.stl")
