
import cadquery as cq

# Define the dimensions of the trapezoids and their placement
base1 = 10.0
base2 = 5.0
height = 20.0
extrude_dist1 = 10.0
extrude_dist2 = 2.0
offset_distance = 11.0  # Offset to place the second trapezoid on the side

# Create the first trapezoid
first_trapezoid = (
    cq.Workplane("front")
    .lineTo(base1 / 2, 0)
    .lineTo(base2 / 2, height)
    .lineTo(-base2 / 2, height)
    .lineTo(-base1 / 2, 0)
    .close()
    .extrude(extrude_dist1)
)

# Create the second trapezoid. It starts from the side of the first trapezoid
second_trapezoid = (
    cq.Workplane("front")
    .workplane(offset=0)  # Align with the base workplane
    .moveTo(offset_distance, 0)  # Move it to the side
    .lineTo((base1 + 2) / 2, 0)
    .lineTo((base2 + 2) / 2, height + 2)
    .lineTo(-(base2 + 2) / 2, height + 2)
    .lineTo(-(base1 + 2) / 2, 0)
    .close()
    .extrude(extrude_dist2)  # Ensure less extrusion
)

# Combine the two trapezoids
result = first_trapezoid.union(second_trapezoid)

# Export the result
result.val().exportStl("Refine_2.stl")
