
import cadquery as cq

# Define the dimensions of the rectangles
large_rectangle_length = 10.0
large_rectangle_width = 5.0
small_rectangle_length = large_rectangle_length / 2
small_rectangle_width = large_rectangle_width / 2

# Define the extrusion amounts
large_rectangle_extrusion = 2.0
small_rectangle_extrusion = large_rectangle_extrusion * 2

# Create the large rectangle in the X-Y plane
large_rectangle = (
    cq.Workplane("XY")
    .rect(large_rectangle_length, large_rectangle_width)
    .extrude(large_rectangle_extrusion)
)

# Create the small rectangle in the Y-Z plane, connected at the edge of the large rectangle
small_rectangle = (
    cq.Workplane("YZ")
    .workplane(offset=-small_rectangle_width/2)
    .transformed(offset=(0, large_rectangle_width/2, large_rectangle_extrusion))
    .rect(small_rectangle_length, small_rectangle_width)
    .extrude(small_rectangle_extrusion, both=True)
)

# Combine the two rectangles
result = large_rectangle.union(small_rectangle)

# Export the result with the correct file name
result.val().exportStl("Refine_2.stl")
