
import cadquery as cq

# Define the points to ensure the lower part of the pentagon is rectangular
points = [(0, 0), (10, 0), (10, 5), (5, 10), (0, 5)]

# Create the workplane and the modified pentagon
result = cq.Workplane("front").polyline(points).close()

# Extrude the modified pentagon to create a pentagonal prism
result = result.extrude(10)

# Export the result
result.val().exportStl("Refine_1.stl")
