
import cadquery as cq

# Revised points to ensure the 5 points make a symmetric pentagon:
# Specifically, ensure the rectangle's top middle point aligns with the center of the base.
points = [(0, 0), (10, 0), (10, 5), (5, 15), (0, 5)]

# Create the workplane and the modified pentagon
result = cq.Workplane("front").polyline(points).close()

# Extrude the modified pentagon to create a pentagonal prism
result = result.extrude(10)

# Export the result
result.val().exportStl("Refine_2.stl")
