
import cadquery as cq

# Parameters
diameter = 100.0  # Diameter of the cylinder
height = 10.0  # Height of the cylinder

# Creating a cylinder
result = (
    cq.Workplane("XY")
    .circle(diameter / 2.0)
    .extrude(height)
)

# Exporting to STL with the revised name
result.val().exportStl("Refine_1.stl")
