
import cadquery as cq

# Define the dimensions of the rectangle and the hole
length = 10.0
width = 5.0
thickness = 2.0
hole_diameter = 1.0

# Create the rectangle and extrude it
result = (
    cq.Workplane("XY")
    .rect(length, width)
    .extrude(thickness)
)

# Add the hole, even more to the left to make it visually distinct
result = (
    result.faces(">Z")
    .workplane()
    .center(-length / 3, 0)  # Increase the left offset
    .hole(hole_diameter)
)

# Export the result with the new file name as per adjustment requirement
result.val().exportStl("Refine_2.stl")
