
import cadquery as cq

# Redefining dimensions for clearer pipe-like appearance
length = 60.0  # Increased length for a more elongated "pipe" look
width = 5.0    # Width of the pipe
height = 5.0   # Height of the pipe
thickness = 1.0  # Wall thickness

# Create the outer part of the pipe
pipe_outer = cq.Workplane("front").box(length, width, height)

# Create the inner part of the pipe
pipe_inner = cq.Workplane("front").box(length - 2*thickness, width - 2*thickness, height)

# Subtract the inner part from the outer part to create the pipe
pipe = pipe_outer.cut(pipe_inner)

# Export the result with the corrected file name
pipe.val().exportStl("Refine_2.stl")
