
import cadquery as cq

# Define the dimensions of the tag
length = 50.0
width = 30.0
thickness = 2.0
radius = 5.0
hole_diameter = 5.0

# Create the tag
result = (
    cq.Workplane("front")
    .rect(length, width)
    .fillet(radius)    # Apply fillet on the 2D object first
    .extrude(thickness)    # Then extrude it to create the solid object
    .faces(">Z")           # Select the top face
    .workplane()           # Start a new workplane from there
    .hole(hole_diameter)   # Now drill the hole
)

# Export the result
result.val().exportStl("Generated.stl")
