
import cadquery as cq

# Define the dimensions of the cylinders
d1, h1 = 10.0, 50.0  # diameter and height of the first cylinder
d2, h2 = d1 / 4, h1 / 8  # diameter and height of the second cylinder
d3, h3 = d2 / 2, h2 * 2  # diameter and height of the third cylinder

# Create the first cylinder
result = cq.Workplane("XY").circle(d1 / 2).extrude(h1)

# Adjust offsets for the second cylinder placement
# Position it slightly below the center of the base of the first cylinder
result = result.faces(">Z").workplane(centerOption="CenterOfBoundBox").transformed(offset=(0, 0, -h1 / 4)).circle(d2 / 2).extrude(h2)

# Create the third cylinder, ensuring it is truly concentric with the second
# It should be concentric, hence we position a workplane right on the top face of the second cylinder
result = result.faces(">Z:last").workplane().circle(d3 / 2).extrude(h3)

# Export the result with the required file name modification
result.val().exportStl("Refine_2.stl")
