
import cadquery as cq

# Define the parameters of the ring
outer_radius = 10.0
inner_radius = 5.0
thickness = 2.0

# Create the ring and correctly extrude along the y-axis
result = (
    cq.Workplane("XY")  # Start a new workplane on the XY plane
    .circle(outer_radius)  # Outer circle with defined radius
    .circle(inner_radius)  # Inner circle with defined radius to create a ring
    .extrude(thickness, both=True)  # Extrude symmetrically along the default extrusion Z-axis but with both=True to create thickness on both sides
)

# Rotate the object to align the extrusion along the y-axis
result = result.rotate((1, 0, 0), (0, 1, 0), 90)

# Export the result in STL format
result.val().exportStl("Refine_2.stl")
