
import cadquery as cq
import math

# Define the side length of the octagon
side_length = 10.0

# Calculate the circumradius of the octagon based on the side length
circumradius = side_length / (2 * math.sin(math.pi / 8))

# Create the octagon and extrude it into a 3D shape
result = (
    cq.Workplane("XY")
    .polygon(8, circumradius)
    .extrude(5.0)  # Extrusion height
)

# Export the result to an STL file with the corrected file name "Refine_2.stl"
result.val().exportStl("Refine_2.stl")
