
import cadquery as cq

# Define the dimensions of the rectangle and trapezium
rect_length = 100.0
rect_width = 20.0
trap_height = 30.0
trap_top_length = 10.0

# Create a combined sketch of a rectangle and an isosceles trapezium
result = cq.Workplane("front")

# Create the rectangle
result = result.rect(rect_length, rect_width)

# Transform the workplane to attach the trapezium at the correct position at one short edge of the rectangle
# Since the rectangle is defined centered on the current workplane, move to the right edge center
result = result.transformed(offset=cq.Vector(rect_length / 2, 0, 0))

# Draw the trapezium sketch
# Start from the bottom-right of the rectangle
trapezium_offset = (rect_width - trap_top_length) / 2
result = result.moveTo(-rect_width / 2, 0) \
                .lineTo(trap_top_length / 2, trap_height) \
                .lineTo(-trap_top_length / 2, trap_height) \
                .lineTo(rect_width / 2, 0) \
                .close()

# Extrude the combined sketch to form the solid object
result = result.extrude(rect_width)  # Extruding perpendicular to the rectangle and trapezium plane

# Export the result
result.val().exportStl("Refine_2.stl")
