
import cadquery as cq

# Define the radius of the outer circle and the radius for the hole
circle_radius = 10.0
hole_radius = circle_radius / 2.0

# Create a workplane, draw a circle and extrude it to form the circular object
result = (
    cq.Workplane("XY")
        .circle(circle_radius)
        .extrude(1.0)  # Adjust the extrusion if a different thickness is required
        .faces(">Z")   # Select the top face
        .workplane()
        .hole(hole_radius * 2)  # The diameter of the hole, `hole_radius * 2`, does give the correct size hole.
)

# Export the result with the corrected file name
result.val().exportStl("Refine_2.stl")
