
import cadquery as cq

# Define the dimensions
rect_length = 10.0
rect_width = 9.0
trap_base = rect_width * 2 / 3
trap_height = trap_base / 10
extrude_amount = 0.5

# Create the rectangle
result = cq.Workplane("front").rect(rect_length, rect_width, forConstruction=True)

# Coordinates for trapezium, with adjustment to position it as described
trap_top = trap_base * (3/5)  # Smaller base of the trapezium
shift_to_center = (rect_length - trap_base) / 2 + trap_height  # Centering adjustment

# Creating isosceles trapezium based on coordinates
result = result.pushPoints([(shift_to_center, rect_width / 2)]).polyline([
    (-trap_base/2, 0),
    (trap_base/2, 0),
    (trap_top/2, trap_height),
    (-trap_top/2, trap_height)
]).close()

# Extrude the sketch
result = result.extrude(extrude_amount)

# Export the result
result.val().exportStl("Refine_1.stl")
