
import cadquery as cq

# Define the dimensions
rect_length = 10.0
rect_width = 9.0
trap_base = rect_width * 2 / 3
trap_height = trap_base / 10 * 3  # Increase height for prominence
extrude_amount = 0.5

# Create the rectangle
result = cq.Workplane("front").rect(rect_length, rect_width, forConstruction=False)

# Coordinates for trapezium, with adjustment to position it as described, marginally to the right
trap_top = trap_base * (3/5)  # Smaller base of the trapezium
shift_to_center = (rect_length - trap_base) / 2 + trap_height * 0.5  # Slight right shift

# Creating isosceles trapezium based on coordinates
result = result.transformed(offset=(shift_to_center - trap_base * 0.15, rect_width / 2)).polyline([
    (-trap_base/2, 0),
    (trap_base/2, 0),
    (trap_top/2, trap_height),
    (-trap_top/2, trap_height)
]).close().extrude(extrude_amount)

# Export the result
result.val().exportStl("Refine_2.stl")
