Python
import cadquery as cq

# Define the dimensions of the pedestal
base_width, base_height = 10.0, 2.0
step_width, step_height = 6.0, 2.0

# Create the base of the pedestal
pedestal = cq.Workplane("front").rect(base_width, base_height)

# Move up to the top of the base and create the second step
pedestal = pedestal.workplane(offset=base_height).center(base_width/2, base_height/2).rect(step_width, step_height)

# Extrude the profile to create the 3D model
pedestal = pedestal.extrude(5.0)

# Save the output
pedestal.val().exportStl("Generated.stl")
