
import cadquery as cq

# Create a workplane
r = cq.Workplane("front")

# Define the radius of the circles such that they overlap
radius_large = 10
radius_small = 5
distance_between_centers = 5  # Adjust this to ensure overlapping

# Create a sketch of two overlapping circles on the same plane
# Ensure circles overlap by setting their centers apart by less than the sum of their radii
r = r.circle(radius_large).moveTo(distance_between_centers, 0).circle(radius_small)

# Extrude the sketch to create a 3D object
result = r.extrude(10)  # The height of the extrusion

# Save the output
result.val().exportStl("Refine_2.stl")
