
import cadquery as cq

# Define the points the polyline will be drawn through for a U shape 
# Modified points for uniform width
points = [(0, 0), (10, 0), (10, 2), (8, 2), (8, 8), (10, 8), (10, 10), (0, 10)]

# Create a workplane and draw the polyline, then close it
result = cq.Workplane("front").polyline(points).close()

# Extrude it into a 3D object
result = result.extrude(1)  # The extrusion length is kept as original which is small.

# Export the revised result to STL
result.val().exportStl("Refine_2.stl")
