
import cadquery as cq

# Define dimensions
length = 80.0  # Length of the rectangle
width = 20.0  # Width of the rectangle
thickness = 10.0  # Thickness of the rectangle
square_size = width  # Width of the square should equal the width of the rectangle
square_thickness = thickness / 3  # Thickness of the square

# Create the rectangle
result = (
    cq.Workplane("XY")
    .rect(length, width)
    .extrude(thickness)
)

# Create the squares, centered aligning with shorter edges (width sides)
for y_offset in [width/2, -width/2]:
    result = (
        result
        .faces(">Z")
        .workplane(centerOption="CenterOfBoundBox")
        .center(0, y_offset)
        .rect(square_size, square_size)
        .extrude(square_thickness, combine=False)
    )

# Export the corrected result
result.val().exportStl("Refine_1.stl")
