
import cadquery as cq

# Define the points the polyline will be drawn through
# Making the vertical arm longer
points = [(0, 0), (0, 20), (10, 20), (10, 19), (1, 19), (1, 0)]

# Create a workplane and draw the L shape using the polyline function
result = cq.Workplane("front").polyline(points).close()

# Extrude the L shape to create a 3D bracket with increased thickness
result = result.extrude(3)

# Export the result to a different STL file
result.val().exportStl("Refine_2.stl")
