
import cadquery as cq

# Define the size of the square and the extrusion depth
square_size = 10.0
extrude_depth = 2.0

# Create a workplane
result = cq.Workplane("front").rect(square_size, square_size)

# Move to the top middle of the square to start the triangle
triangle_top_x = square_size / 2
triangle_top_y = square_size
result = result.moveTo(triangle_top_x, triangle_top_y)

# Create a right-angle triangle at the top of the square
result = result.polyline([
    (0, 0), 
    (square_size / 2, square_size),  # Triangle right vertex at the top right of the square
    (-square_size / 2, square_size), # Triangle left vertex at the top left of the square
    (0, 0)  # Back to the origin
]).close()

# Extruding the sketch to form the 3D object
result = result.extrude(extrude_depth)

# Export the updated result to STL
result.val().exportStl("Refine_1.stl")
