
import cadquery as cq

# Define the dimensions
square_side = 10.0  # Side length of the square
thickness = 0.5  # Thickness of the square
hole_diameter = 0.5  # Adjusted diameter of the hole for better visibility and practicality

# Create the square and extrude it
result = (
    cq.Workplane("XY")
    .rect(square_side, square_side)
    .extrude(thickness)
)

# Create the hole in the center of the square
result = (
    result.faces(">Z")
    .workplane()
    .hole(hole_diameter)
)

# Export the result
result.val().exportStl("Refine_2.stl")
