
import cadquery as cq

# Create a workplane
result = cq.Workpoolane("XY")

# Draw the outer circle and create a solid by extruding
outer_solid = result.circle(10).extrude(5)

# Create a new workplane that is transformed for the inner circle
inner_workplane = result.transformed(offset=cq.Vector(-3, 0, 0))

# Draw the inner circle on the new workplane and extrude
inner_solid = inner_workplane.circle(8).extrude(5)

# Subtract the two solids to get the crescent shape
crescent_shape = outer_solid.cut(inner_solid)

# Export the result
crescent_shape.exportStl("Refine_1.stl")
